<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Booking extends Model 
{

    protected $table = 'bookings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function status()
    {
        return $this->hasOne('App\Models\Status', 'id');
    }

    public function phone()
    {
        return $this->hasOne('App\Models\Phone', 'id');
    }

    public function photos()
    {
        return $this->hasMany('App\Models\BookingPhoto', 'booking_id');
    }

    public function technician()
    {
        return $this->hasOne('App\Models\Technician', 'id');
    }

}